/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae;

import com.obscuria.aquamirae.AquamiraeUtils;
import com.obscuria.aquamirae.client.AquamiraeLayers;
import com.obscuria.aquamirae.client.AquamiraeRenderers;
import com.obscuria.aquamirae.network.ScrollUsePacket;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5195;
import net.minecraft.class_6880;
import net.minecraft.class_746;

public final class AquamiraeClient
implements ClientModInitializer {
    private static int biomeMusic = 0;
    private static int corneliaMusic = 0;

    public void onInitializeClient() {
        AquamiraeLayers.register();
        AquamiraeRenderers.register();
        ClientPlayNetworking.registerGlobalReceiver(ScrollUsePacket.TYPE, (packet, player, responseSender) -> AquamiraeClient.scrollSound());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_746 player;
            if (class_310.method_1551().field_1724 == null || class_310.method_1551().method_1493()) {
                return;
            }
            if (biomeMusic > 0) {
                --biomeMusic;
            }
            if (corneliaMusic > 0) {
                --corneliaMusic;
            }
            if (AquamiraeUtils.isInIceMaze((class_1297)(player = class_310.method_1551().field_1724))) {
                AquamiraeClient.playAmbientSounds((class_1657)player, true);
                AquamiraeClient.playBiomeMusic((class_1657)player);
                AquamiraeClient.spawnParticles((class_1657)player);
            }
        });
    }

    public static boolean isStackHeld(class_1799 stack) {
        return class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_6047() == stack;
    }

    public static void showFloatingItem(class_1799 stack) {
        class_310.method_1551().field_1773.method_3189(stack);
    }

    public static void scrollSound() {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_310.method_1551().field_1724.method_5783(AquamiraeSounds.EFFECT_MYSTERY, 1.0f, 1.0f);
    }

    public static void spawnParticles(class_1657 player) {
        player.method_37908().method_8466((class_2394)class_2398.field_23956, false, player.method_23317() - 6.0 + 12.0 * player.method_6051().method_43058(), player.method_23318() + 4.0 - 3.0 * player.method_6051().method_43058(), player.method_23321() - 6.0 + 12.0 * player.method_6051().method_43058(), 0.0, 100.0, 0.0);
    }

    public static void playAmbientSounds(class_1657 player, boolean random) {
        if (!random || Math.random() <= 0.01 && Math.random() <= 0.1) {
            player.method_37908().method_8486((double)(player.method_31477() - 10) + 20.0 * Math.random(), (double)player.method_31478(), (double)(player.method_31479() - 10) + 20.0 * Math.random(), AquamiraeSounds.AMBIENT_SHIP_HORN, class_3419.field_15256, 1.0f, 1.0f, false);
        }
    }

    public static void playCorneliaMusic(class_1657 player) {
        if (player.method_5805() && corneliaMusic <= 0) {
            corneliaMusic = 3000;
            class_310.method_1551().method_1538().method_4859();
            class_310.method_1551().method_1538().method_4858(new class_5195(class_6880.method_40223((Object)AquamiraeSounds.MUSIC_FORSAKEN_DROWNAGE), 10, 100, true));
        }
    }

    private static void playBiomeMusic(class_1657 player) {
        if (player.method_5805() && biomeMusic <= 0 && corneliaMusic <= 0) {
            biomeMusic = 20 * new Random().nextInt(180, 300);
            class_310.method_1551().method_1538().method_4859();
            class_310.method_1551().method_1538().method_4858(new class_5195(class_6880.method_40223((Object)AquamiraeSounds.MUSIC_ICE_MAZE_THEME), 10, 100, true));
        }
    }
}

